import { z } from "zod";
export declare const RequestSchema: z.ZodObject<{
    type: z.ZodString;
    timestamp: z.ZodEffects<z.ZodDate, Date, unknown>;
    body: z.ZodRecord<z.ZodString, z.ZodAny>;
}, "strip", z.ZodTypeAny, {
    type: string;
    timestamp: Date;
    body: Record<string, any>;
}, {
    type: string;
    body: Record<string, any>;
    timestamp?: unknown;
}>;
export declare type Request = z.infer<typeof RequestSchema>;
export declare type Response = {
    status: "ok";
    body: Record<string, unknown>;
} | {
    status: "error";
    metadata: Record<string, unknown>;
};
export declare type RequestHandler = (request: Request) => Promise<Response>;
